/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.spi.AudioRecording;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

class JSAudioRecordingClip
implements AudioRecording {
    private Clip c;
    private int loopCount;
    private AudioMetaData meta;
    private boolean playing;

    JSAudioRecordingClip(Clip clip, AudioMetaData audioMetaData) {
        this.c = clip;
        this.c.addLineListener(new LineListener(){

            @Override
            public void update(LineEvent lineEvent) {
                if (lineEvent.getType().equals(LineEvent.Type.STOP)) {
                    if (JSAudioRecordingClip.this.playing && JSAudioRecordingClip.this.loopCount != 0) {
                        JSAudioRecordingClip.this.c.setMicrosecondPosition(0L);
                        JSAudioRecordingClip.this.c.start();
                        if (JSAudioRecordingClip.this.loopCount > 0) {
                            JSAudioRecordingClip.this.loopCount--;
                        }
                    } else {
                        JSAudioRecordingClip.this.playing = false;
                    }
                }
            }
        });
        this.playing = false;
        this.loopCount = 0;
        this.meta = audioMetaData;
    }

    @Override
    public int getLoopCount() {
        return this.loopCount;
    }

    @Override
    public int getMillisecondLength() {
        return (int)this.c.getMicrosecondLength() / 1000;
    }

    @Override
    public int getMillisecondPosition() {
        return (int)this.c.getMicrosecondPosition() / 1000;
    }

    @Override
    public AudioMetaData getMetaData() {
        return this.meta;
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public void loop(int n) {
        this.play();
        this.loopCount = n;
    }

    @Override
    public void setLoopPoints(int n, int n2) {
        this.c.setLoopPoints(n, n2);
    }

    @Override
    public void setMillisecondPosition(int n) {
        this.c.setMicrosecondPosition(n * 1000);
    }

    @Override
    public void play() {
        if (this.c.getMicrosecondPosition() != this.c.getMicrosecondLength()) {
            this.c.start();
            this.playing = true;
        }
    }

    @Override
    public void pause() {
        this.c.stop();
        this.playing = false;
    }

    @Override
    public void close() {
        this.c.close();
    }

    @Override
    public Control[] getControls() {
        return this.c.getControls();
    }

    @Override
    public AudioFormat getFormat() {
        return this.c.getFormat();
    }

    @Override
    public void open() {
    }

    public int bufferSize() {
        return 0;
    }

    @Override
    public float[] read() {
        return null;
    }

    @Override
    public void read(MultiChannelBuffer multiChannelBuffer) {
    }
}

